% © 2026 Jan-Luca Hansel <hanseljl@mail.uni-paderborn.de>
% Licensed under the EUPL

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{targetagreementUPB}[2026/02/11 Target agreement template for Paderborn University]

% Boolean variables
\newif\if@german\@germanfalse		% Thesis written primarily in German?
\newif\if@british\@britishfalse		% Thesis uses British English either primarily or secondarily?

% Declare and process all options
\DeclareOption{de-gb}{\@germantrue\@britishtrue}	% Thesis is written primarily in German but British English may also be used
\DeclareOption{de-us}{\@germantrue\@britishfalse}	% Thesis is written primarily in German but American English may also be used
\DeclareOption{gb-de}{\@germanfalse\@britishtrue}	% Thesis is written primarily in British English and German will be loaded as a secondary option
\DeclareOption{us-de}{\@germanfalse\@britishfalse}	% Thesis is written primarily in American English and German will be loaded as a secondary option
\DeclareOption*{\OptionNotUsed}						% Nothing else is supported
\ProcessOptions\relax

% This class build on top of book
\LoadClass[a4paper]{article}

% Correct langage support based on @german
\if@german
	\if@british
		\RequirePackage[british,ngerman]{babel}
	\else
		\RequirePackage[american,ngerman]{babel}
	\fi
	\RequirePackage[ngerman]{selnolig}
\else
	\if@british
		\RequirePackage[ngerman,british]{babel}
	\else
		\RequirePackage[ngerman,american]{babel}
	\fi
	\RequirePackage[english]{selnolig}
\fi

% Define grid variables
\newcommand{\xgrid}{\dimexpr \paperwidth / 9 \relax}
\newcommand{\ygrid}{\dimexpr \paperheight / 9 \relax}

% Page construction using 6×6 rectangles on a 9×9 grid
\RequirePackage[
	a4paper,
	left=\dimexpr 1.5\xgrid \relax,
	right=\dimexpr 1.5\xgrid \relax,
	top=\ygrid,
	bottom=\dimexpr \ygrid * 2 \relax,
]{geometry}

% Use tikz
\RequirePackage{tikz}
\usetikzlibrary{backgrounds,positioning}

% Setup fonts
\RequirePackage{fontspec}
\setmainfont{Latin Modern Roman}[
	SmallCapsFont=Latin Modern Roman Caps,
	SmallCapsFeatures={LetterSpace=1.1},
	Numbers={OldStyle,Proportional}
]
\setsansfont{Karla}[
    Path=./fonts/,
    Extension=.ttf,
    UprightFont=*-Regular,
    BoldFont=*-Bold,
    ItalicFont=*-Italic,
	Numbers={Lining,Tabular}
]
\setmonofont{Latin Modern Mono Prop}

% Graphics
\RequirePackage{graphicx}
\graphicspath{{figures/}}

% Control over headings
\RequirePackage[explicit,sf,bf]{titlesec}

% Draw boxes
\RequirePackage[most]{tcolorbox}

% Microtypography
\RequirePackage[letterspace=50]{microtype}

% Boxes
\RequirePackage[export]{adjustbox}

% Math
\RequirePackage{amsmath}
\RequirePackage{amsthm}
\RequirePackage{amssymb}

\RequirePackage{xfrac}

% Source code listings
\RequirePackage[newfloat]{minted}
\setminted{tabsize=4,autogobble,fontsize=\small}
\RecustomVerbatimEnvironment{Verbatim}{BVerbatim}{}

% Pseudocode
\RequirePackage{algorithm}
\RequirePackage{algpseudocodex}

% Tables
\RequirePackage{tabularray}
\UseTblrLibrary{booktabs}
\UseTblrLibrary{amsmath}
\UseTblrLibrary{diagbox}

\RequirePackage{caption} 
\captionsetup{margin=10pt,labelfont={bf,sf},belowskip=5pt,aboveskip=5pt}

% Gantt chart
\usepackage{pgfgantt}

% Placement of floats
\SetupFloatingEnvironment{figure}{placement=tp}
\SetupFloatingEnvironment{table}{placement=tp}
\SetupFloatingEnvironment{listing}{placement=tp}

% Alternative floats
\RequirePackage{float}
\floatstyle{plaintop}

\newfloat{hfigure}{h}{lof}
\newfloat{htable}{h}{lot}
\newfloat{hlisting}{h}{lol}

\let\c@hfigure\c@figure
\let\c@htable\c@table
\let\c@hlisting\c@listing

% Better enumerations
\RequirePackage[inline]{enumitem}
\setlist{itemsep=1pt}

% Quotations
\if@british
	\RequirePackage[autostyle,german=guillemets,english=british]{csquotes}
\else
	\RequirePackage[autostyle,german=guillemets,english=american]{csquotes}
\fi

\RequirePackage{lettrine}
\renewcommand{\mkbegdispquote}[2]{{\tiny\bfseries\lettrine[lhang=1,nindent=0pt,loversize=1]{\textooquote}{}}\small}

\RequirePackage[backend=biber,style=apa]{biblatex}
\setlength{\bibitemsep}{1.5\itemsep}
\setlength{\bibhang}{\parindent}
\RequirePackage[hidelinks]{hyperref}
\RequirePackage{url}
\urlstyle{tt}
\DeclareFieldFormat*{citetitle}{\itshape #1}

\if@german
	\RequirePackage[english,ngerman]{cleveref}
\else
	\RequirePackage[ngerman,english]{cleveref}
\fi

% Names for new floats
\if@german
	\floatname{hfigure}{Abbildung}
	\crefname{hfigure}{Abbildung}{Abbildungen}
	\Crefname{hfigure}{Abbildung}{Abbildungen}

	\floatname{htable}{Tabelle}
	\crefname{htable}{Tabelle}{Tabellen}
	\Crefname{htable}{Tabelle}{Tabellen}

	\floatname{hlisting}{Listing}
	\crefname{hlisting}{Listing}{Listings}
	\Crefname{hlisting}{Listing}{Listings}
\else
	\floatname{hfigure}{Figure}
	\crefname{hfigure}{figure}{figures}
	\Crefname{hfigure}{Figure}{Figures}

	\floatname{htable}{Table}
	\crefname{htable}{table}{tables}
	\Crefname{htable}{Table}{Tables}

	\floatname{hlisting}{Listing}
	\crefname{hlisting}{listing}{listings}
	\Crefname{hlisting}{Listing}{Listings}
\fi

% Footer
\RequirePackage{fancyhdr}
\fancypagestyle{plain}{%
	\fancyhf{}
	\fancyfoot[R]{\sffamily\addfontfeatures{Numbers={Lining,Tabular}}\thepage}
	\renewcommand{\headrulewidth}{0pt}
	\renewcommand{\footrulewidth}{0pt}
}
\pagestyle{plain}

% Use tabular lining figures for tables
\AtBeginEnvironment{tblr}{\addfontfeatures{Numbers={Lining,Tabular}}}
\AtBeginEnvironment{ganttchart}{\sffamily}

% Use monospaced font for listings
\AtBeginEnvironment{minted}{\setmonofont{Latin Modern Mono}}
\AtEndEnvironment{minted}{\setmonofont{Latin Modern Mono Prop}}

% Always center tables and figures
\addto\figure{\centering}
\addto\hfigure{\centering}
\addto\table{\centering}
\addto\htable{\centering}
\addto\listing{\centering}
\addto\hlisting{\centering}

% Footer more towards the bottom of the page
\setlength{\footskip}{3\baselineskip}

\if@german
	\newcommand{\logo}{\includegraphics[width=\dimexpr \xgrid * 3 \relax]{figures/logo_de}}
\else
	\newcommand{\logo}{\includegraphics[width=\dimexpr \xgrid * 3 \relax]{figures/logo_en}}
\fi

% Layout of the title
\newcommand{\printtitle}{
	\hspace{-1.25cm}
	\begin{tikzpicture}
		\node[anchor=south west] at (\dimexpr \xgrid - 6mm \relax,\dimexpr \ygrid * 7 + 3.25mm \relax) {\logo};

		\node[anchor=south west] at (\dimexpr \xgrid * 4 - 1mm \relax,\dimexpr \ygrid * 7 \relax) {
			\parbox[c][\dimexpr \ygrid - \fboxsep * 2 \relax]{\dimexpr \xgrid * 3 - \fboxsep * 2 - 5mm \relax}{
				\sffamily
				\small
				\vspace*{11pt}
				\if@german
					Fakultät für Elektrotechnik, \\
					Informatik und Mathematik \\[5pt]
					Institut für Informatik
				\else
					Faculty for Computer Science, \\
					Electrical Engineering and Mathematics \\[5pt]
					Department of Computer Science
				\fi
			}
		};

		\filldraw[lightgray] (\dimexpr \xgrid * 4 - 6mm \relax, \dimexpr \ygrid * 7 + \ygrid * 1/8 \relax) -- ++(0,\dimexpr \ygrid * 3/4 \relax) -- ++(38:2pt) -- ++(0,\dimexpr \ygrid * -3/4 \relax) -- cycle;
	\end{tikzpicture}

	\if@german
		\section*{Zielvereinbarung zur \@thesistype}
	\else
		\section*{Target agreement for a \@thesistype}
	\fi

	\begin{tblr}{
		colspec = {lX},
		column{1} = {colsep=0pt}
	}
		\if@german Titel der Arbeit:\else Thesis title:\fi & \@title	\\
		\if@german Bearbeitet von:\else Written by:\fi	   & \@author	\\
	\end{tblr}
}

% Layout of signatures
\newcommand{\printagreement}{
	\if@german
		\section{Vereinbarung}

		\@supervisor{} und \@author{} vereinbaren die oben stehende Aufgabenstellung zur Durchführung der \@thesistype.
	\else
		\section{Agreement}

		\@supervisor{} and \@author{} agree to the tasks outlined above for the creation of a \@thesistype{}.
	\fi

	\noindent\begin{tblr}{
		colspec={X[c]cX[c]},
		row{1}={ht=2cm},
		column{2}={wd=1cm},
		column{1,3} = {colsep=0pt}
	}
						& &            \\
		\hrulefill		& & \hrulefill \\
		\@supervisor	& & \@author
	\end{tblr}
}

% Variables
\newcommand{\@surname}{---}
\newcommand{\@name}{---}
\renewcommand{\@author}{\@name \@surname}
\renewcommand{\@title}{---}
\newcommand{\@thesistype}{---}
\newcommand{\@supervisor}{---}
\newcommand{\surname}[1]{\renewcommand{\@surname}{#1}}
\newcommand{\name}[1]{\renewcommand{\@name}{#1}}
\newcommand{\thesistype}[1]{\renewcommand{\@thesistype}{#1}}
\newcommand{\supervisor}[1]{\renewcommand{\@supervisor}{#1}}

% Color definitions
\definecolor{upbUltraBlue}{RGB}{0,37,170}
\definecolor{upbSkyBlue}{RGB}{10,117,196}
\definecolor{upbSapphireBlue}{RGB}{24,28,98}
\definecolor{upbIrisViolet}{RGB}{126,63,168}
\definecolor{upbFuchsiaRed}{RGB}{193,56,160}
\definecolor{upbOceanBlue}{RGB}{35,169,201}
\definecolor{upbArcticBlue}{RGB}{80,209,209}
\definecolor{upbGarnetPink}{RGB}{238,40,138}
\definecolor{upbLimeGreen}{RGB}{165,206,66}

% Define boxes
\tcbset { 
	base/.style={
		breakable,
		% Outer box
		enhanced jigsaw,
	    arc=0mm, 
	    boxrule=0mm,
	    leftrule=1mm,
		% Colors
		colbacktitle={white},
		opacitybacktitle=0,
		colback={white},
		opacityback=0,
		% Title
	    coltitle=black, 
	    fonttitle=\sffamily\bfseries, 
		% Margins
		before skip balanced=\dimexpr \baselineskip + 2pt \relax,
		after skip balanced=\dimexpr \baselineskip + 2pt \relax,
	    left=2.5mm,
	    right=3.5mm,
	}
}

\newtcolorbox{upbbox}[1][black]{
	% Colors
	colframe={#1},
	% See definition of base
	base
}

\newtcolorbox{upbtitlebox}[2][black]{
	% Colors
	colframe={#1},
	% Title text
	title={#2},
	% Margins
	toptitle=1mm, 
	bottomtitle=1mm,
	top=1mm,
	% See definition of base
	base
}

% Math environments
% Definition
\newcounter{definition}

\newenvironment{definition}[1]
{
	\refstepcounter{definition}
	\begin{upbtitlebox}[upbSapphireBlue]{Definition~\thedefinition: \mdseries #1}
}
{
	\end{upbtitlebox}
}

\if@german
	\crefname{definition}{Definition}{Definitionen}
	\Crefname{definition}{Definition}{Definitionen}
	\crefformat{definition}{#2Definition~#1#3}
	\Crefformat{definition}{#2Definition~#1#3}
	\crefrangeformat{definition}{#3Definitionen~#1#4 bis~#5#2#6}
	\Crefrangeformat{definition}{#3Definitionen~#1#4 bis~#5#2#6}
	\crefmultiformat{definition}{Definitionen~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{definition}{Definitionen~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{definition}{definition}{definitions}
	\Crefname{definition}{Definition}{Definitions}
	\crefformat{definition}{#2definition~#1#3}
	\Crefformat{definition}{#2Definition~#1#3}
	\crefrangeformat{definition}{#3definitions~#1#4 to~#5#2#6}
	\Crefrangeformat{definition}{#3Definitions~#1#4 to~#5#2#6}
	\crefmultiformat{definition}{definitions~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{definition}{Definitions~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Observation
\newcounter{observation}

\newenvironment{observation}[1]
{
	\refstepcounter{observation}
	\if@german
		\begin{upbtitlebox}[upbLimeGreen]{Beobachtung~\theobservation: \mdseries #1}
	\else
		\begin{upbtitlebox}[upbLimeGreen]{Observation~\theobservation: \mdseries #1}
	\fi
}
{
	\end{upbtitlebox}
}

\if@german
	\crefname{observation}{Beobachtung}{Beobachtungen}
	\Crefname{observation}{Beobachtung}{Beobachtungen}
	\crefformat{observation}{#2Beobachtung~#1#3}
	\Crefformat{observation}{#2Beobachtung~#1#3}
	\crefrangeformat{observation}{#3Beobachtungen~#1#4 bis~#5#2#6}
	\Crefrangeformat{observation}{#3Beobachtungen~#1#4 bis~#5#2#6}
	\crefmultiformat{observation}{Beobachtungen~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{observation}{Beobachtungen~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{observation}{observation}{observations}
	\Crefname{observation}{Observation}{Observations}
	\crefformat{observation}{#2observation~#1#3}
	\Crefformat{observation}{#2Observation~#1#3}
	\crefrangeformat{observation}{#3observations~#1#4 to~#5#2#6}
	\Crefrangeformat{observation}{#3Observations~#1#4 to~#5#2#6}
	\crefmultiformat{observation}{observations~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{observation}{Observations~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Theorem
\newcounter{theorem}

\newenvironment{theorem}[1]
{
	\refstepcounter{theorem}
	\if@german
		\begin{upbtitlebox}[black]{Satz~\thetheorem: \mdseries #1}
	\else
		\begin{upbtitlebox}[black]{Theorem~\thetheorem: \mdseries #1}
	\fi
}
{
	\end{upbtitlebox}
}
\if@german
	\crefname{theorem}{Satz}{Sätze}
	\Crefname{theorem}{Satz}{Sätze}
	\crefformat{theorem}{#2Satz~#1#3}
	\Crefformat{theorem}{#2Satz~#1#3}
	\crefrangeformat{theorem}{#3Sätze~#1#4 bis~#5#2#6}
	\Crefrangeformat{theorem}{#3Sätze~#1#4 bis~#5#2#6}
	\crefmultiformat{theorem}{Sätze~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{theorem}{Sätze~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{theorem}{theorem}{theorems}
	\Crefname{theorem}{Theorem}{Theorems}
	\crefformat{theorem}{#2theorem~#1#3}
	\Crefformat{theorem}{#2Theorem~#1#3}
	\crefrangeformat{theorem}{#3theorems~#1#4 to~#5#2#6}
	\Crefrangeformat{theorem}{#3Theorems~#1#4 to~#5#2#6}
	\crefmultiformat{theorem}{theorems~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{theorem}{Theorems~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Lemma
\newcounter{lemma}

\newenvironment{lemma}[1]
{
	\refstepcounter{lemma}
	\begin{upbtitlebox}[upbIrisViolet]{Lemma~\thelemma: \mdseries #1}
}
{
	\end{upbtitlebox}
}

\Crefname{lemma}{Lemma}{Lemmata}
\Crefformat{lemma}{#2Lemma~#1#3}
\if@german
	\crefname{lemma}{Lemma}{Lemmata}
	\crefformat{lemma}{#2Lemma~#1#3}
	\crefrangeformat{lemma}{#3Lemmata~#1#4 bis~#5#2#6}
	\Crefrangeformat{lemma}{#3Lemmata~#1#4 bis~#5#2#6}
	\crefmultiformat{lemma}{Lemmata~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{lemma}{Lemmata~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{lemma}{lemma}{lemmata}
	\crefformat{lemma}{#2lemma~#1#3}
	\Crefformat{lemma}{#2Lemma~#1#3}
	\crefrangeformat{lemma}{#3lemmata~#1#4 to~#5#2#6}
	\Crefrangeformat{lemma}{#3Lemmata~#1#4 to~#5#2#6}
	\crefmultiformat{lemma}{lemmata~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{lemma}{Lemmata~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Corollary
\newcounter{corollary}

\newenvironment{corollary}[1]
{
	\refstepcounter{corollary}
	\if@german
		\begin{upbtitlebox}[upbGarnetPink]{Korollar~\thecorollary: \mdseries #1}
	\else
		\begin{upbtitlebox}[upbGarnetPink]{Corollary~\thecorollary: \mdseries #1}
	\fi
}
{
	\end{upbtitlebox}
}

\if@german
	\crefname{corollary}{Korollar}{Korollare}
	\Crefname{corollary}{Korollar}{Korollare}
	\crefformat{corollary}{#2Korollar~#1#3}
	\Crefformat{corollary}{#2Korollar~#1#3}
	\crefrangeformat{corollary}{#3Korollare~#1#4 bis~#5#2#6}
	\Crefrangeformat{corollary}{#3Korollare~#1#4 bis~#5#2#6}
	\crefmultiformat{corollary}{Korollare~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{corollary}{Korollare~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{corollary}{corollary}{corollaries}
	\Crefname{corollary}{Corollary}{Corollaries}
	\crefformat{corollary}{#2corollary~#1#3}
	\Crefformat{corollary}{#2Corollary~#1#3}
	\crefrangeformat{corollary}{#3corollaries~#1#4 to~#5#2#6}
	\Crefrangeformat{corollary}{#3Corollaries~#1#4 to~#5#2#6}
	\crefmultiformat{corollary}{corollaries~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{corollary}{Corollaries~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Proof
\renewenvironment{proof}[1]
{
	\pushQED{\qed}%
	\if@german
		\begin{upbtitlebox}[black!25]{Beweis: \mdseries #1}
	\else
		\begin{upbtitlebox}[black!25]{Proof: \mdseries #1}
	\fi
}
{
	\popQED\endtrivlist\@endpefalse
	\end{upbtitlebox}
}

% Semantic markup
\newcommand{\code}[1]{\texttt{#1}}
\newcommand{\term}[1]{\textsc{#1}}
\newcommand{\todo}[1]{\colorbox{upbFuchsiaRed}{\sffamily\strong{\textcolor{white}{#1}}}}

% Abbreviations
\if@german
	\newcommand\zB{z.\,B.}
	\newcommand\ua{u.\,a.}
	\newcommand\uAe{u.\,Ä.}
	\newcommand\oAe{o.\,Ä.}
\fi
