% © 2026 Jan-Luca Hansel <hanseljl@mail.uni-paderborn.de>
% Licensed under the EUPL

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{thesisUPB}[2026/02/11 Thesis template for Paderborn University]

% Boolean variables
\newif\if@german\@germanfalse		% Thesis written primarily in German?
\newif\if@british\@britishfalse		% Thesis uses British English either primarily or secondarily?
\newif\if@color\@colorfalse			% Use extra color highlights?
\newif\if@showgrid\@showgridfalse	% Show the grid?

% Declare and process all options
\DeclareOption{de-gb}{\@germantrue\@britishtrue}	% Thesis is written primarily in German but British English may also be used
\DeclareOption{de-us}{\@germantrue\@britishfalse}	% Thesis is written primarily in German but American English may also be used
\DeclareOption{gb-de}{\@germanfalse\@britishtrue}	% Thesis is written primarily in British English and German will be loaded as a secondary option
\DeclareOption{us-de}{\@germanfalse\@britishfalse}	% Thesis is written primarily in American English and German will be loaded as a secondary option
\DeclareOption{color}{\@colortrue}					% Use extra color highlights?
\DeclareOption{showgrid}{\@showgridtrue}			% Grid/No grid?
\DeclareOption*{\OptionNotUsed}						% Nothing else is supported
\ProcessOptions\relax

% This class build on top of book
\LoadClass[a4paper, twoside, openright]{book}

% Correct langage support based on @german
\if@german
	\if@british
		\RequirePackage[british,ngerman]{babel}
	\else
		\RequirePackage[american,ngerman]{babel}
	\fi
	\RequirePackage[ngerman]{selnolig}
\else
	\if@british
		\RequirePackage[ngerman,british]{babel}
	\else
		\RequirePackage[ngerman,american]{babel}
	\fi
	\RequirePackage[english]{selnolig}
\fi

% Define grid variables
\newcommand{\xgrid}{\dimexpr \paperwidth / 9 \relax}
\newcommand{\ygrid}{\dimexpr \paperheight / 9 \relax}

% Page construction using 6×6 rectangles on a 9×9 grid
\RequirePackage[
	a4paper,
	twoside,
	inner=\xgrid,
	outer=\dimexpr \xgrid * 2 \relax,
	top=\ygrid,
	bottom=\dimexpr \ygrid * 2 \relax,
]{geometry}

% Use tikz
\RequirePackage{tikz}
\usetikzlibrary{backgrounds,positioning}

% Show an optional grid
\if@showgrid
	\RequirePackage{eso-pic}
	\AddToShipoutPictureBG{%
		\begin{tikzpicture}[remember picture, overlay]
			\draw[lightgray,xstep=\xgrid,ystep=\ygrid] (current page.north west) grid (current page.south east);
		\end{tikzpicture}%
	}
	\geometry{showframe}
\fi

% Setup fonts
\RequirePackage{fontspec}
\setmainfont{Latin Modern Roman}[
	SmallCapsFont=Latin Modern Roman Caps,
	SmallCapsFeatures={LetterSpace=1.1},
	Numbers={OldStyle,Proportional}
]
\setsansfont{Karla}[
    Path=./fonts/,
    Extension=.ttf,
    UprightFont=*-Regular,
    BoldFont=*-Bold,
    ItalicFont=*-Italic,
	Numbers={Lining,Tabular}
]
\setmonofont{Latin Modern Mono Prop}

% Set the highlighting color
\if@color
	\definecolor{upbHighlight}{RGB}{0,37,170}
\else
	\definecolor{upbHighlight}{RGB}{0,0,0}
\fi

% Graphics
\RequirePackage{graphicx}
\graphicspath{{figures/}}

% Control over headings
\RequirePackage[explicit,sf,bf]{titlesec}

% Draw boxes
\RequirePackage[most]{tcolorbox}

% Microtypography
\RequirePackage[letterspace=50]{microtype}

% Let empty pages be empty
\RequirePackage{emptypage}

% Boxes
\RequirePackage[export]{adjustbox}

% Math
\RequirePackage{amsmath}
\RequirePackage{amsthm}
\RequirePackage{amssymb}

\RequirePackage{xfrac}

% Source code listings
\RequirePackage[newfloat]{minted}
\setminted{tabsize=4,autogobble,fontsize=\small}
\RecustomVerbatimEnvironment{Verbatim}{BVerbatim}{}

% Pseudocode
\RequirePackage{algorithm}
\RequirePackage{algpseudocodex}

% Tables
\RequirePackage{tabularray}
\UseTblrLibrary{booktabs}
\UseTblrLibrary{amsmath}
\UseTblrLibrary{diagbox}

\RequirePackage{caption} 
\captionsetup{margin=10pt,labelfont={bf,sf},belowskip=5pt,aboveskip=5pt}

% Placement of floats
\SetupFloatingEnvironment{figure}{placement=tp}
\SetupFloatingEnvironment{table}{placement=tp}
\SetupFloatingEnvironment{listing}{placement=tp}

% Alternative floats
\RequirePackage{float}
\floatstyle{plaintop}

\newfloat{hfigure}{h}{lof}[chapter]
\newfloat{htable}{h}{lot}[chapter]
\newfloat{hlisting}{h}{lol}[chapter]

\let\c@hfigure\c@figure
\let\c@htable\c@table
\let\c@hlisting\c@listing

% Better enumerations
\RequirePackage[inline]{enumitem}
\setlist{itemsep=1pt}

% Quotations
\if@british
	\RequirePackage[autostyle,german=guillemets,english=british]{csquotes}
\else
	\RequirePackage[autostyle,german=guillemets,english=american]{csquotes}
\fi

\RequirePackage{lettrine}
\renewcommand{\mkbegdispquote}[2]{{\tiny\bfseries\lettrine[lhang=1,nindent=0pt,loversize=1]{\textooquote}{}}\small}

\RequirePackage[backend=biber,style=apa]{biblatex}
\setlength{\bibitemsep}{1.5\itemsep}
\setlength{\bibhang}{\parindent}
\RequirePackage[hidelinks]{hyperref}
\RequirePackage{url}
\urlstyle{tt}
\DeclareFieldFormat*{citetitle}{\itshape #1}

\if@german
	\RequirePackage[english,ngerman]{cleveref}
\else
	\RequirePackage[ngerman,english]{cleveref}
\fi

% Names for new floats
\if@german
	\floatname{hfigure}{Abbildung}
	\crefname{hfigure}{Abbildung}{Abbildungen}
	\Crefname{hfigure}{Abbildung}{Abbildungen}

	\floatname{htable}{Tabelle}
	\crefname{htable}{Tabelle}{Tabellen}
	\Crefname{htable}{Tabelle}{Tabellen}

	\floatname{hlisting}{Listing}
	\crefname{hlisting}{Listing}{Listings}
	\Crefname{hlisting}{Listing}{Listings}
\else
	\floatname{hfigure}{Figure}
	\crefname{hfigure}{figure}{figures}
	\Crefname{hfigure}{Figure}{Figures}

	\floatname{htable}{Table}
	\crefname{htable}{table}{tables}
	\Crefname{htable}{Table}{Tables}

	\floatname{hlisting}{Listing}
	\crefname{hlisting}{listing}{listings}
	\Crefname{hlisting}{Listing}{Listings}
\fi

% Footer
\RequirePackage{fancyhdr}
\fancypagestyle{plain}{%
	\fancyhf{}
	\fancyfoot[LE]{\sffamily\addfontfeatures{Numbers={Lining,Tabular}}\thepage}
	\fancyfoot[RO]{\sffamily\addfontfeatures{Numbers={Lining,Tabular}}\thepage}
	\renewcommand{\headrulewidth}{0pt}
	\renewcommand{\footrulewidth}{0pt}
}
\fancypagestyle{thesisupb}{%
	\fancyhf{}
	\fancyhead[LE]{\sffamily\nouppercase{\leftmark}}
	\fancyhead[RO]{\sffamily\nouppercase{\rightmark}}
	\fancyfoot[LE]{\sffamily\addfontfeatures{Numbers={Lining,Tabular}}\thepage}
	\fancyfoot[RO]{\sffamily\addfontfeatures{Numbers={Lining,Tabular}}\thepage}
	\renewcommand{\headrulewidth}{0pt}
	\renewcommand{\footrulewidth}{0pt}
}

% Use tabular lining figures for tables
\AtBeginEnvironment{tblr}{\addfontfeatures{Numbers={Lining,Tabular}}}

% Use monospaced font for listings
\AtBeginEnvironment{minted}{\setmonofont{Latin Modern Mono}}
\AtEndEnvironment{minted}{\setmonofont{Latin Modern Mono Prop}}

% Always center tables and figures
\addto\figure{\centering}
\addto\hfigure{\centering}
\addto\table{\centering}
\addto\htable{\centering}
\addto\listing{\centering}
\addto\hlisting{\centering}

% Table of contents
\RequirePackage[titles]{tocloft}

\renewcommand{\cftpartfont}{\sffamily\bfseries}
\renewcommand{\cftpartpagefont}{\sffamily\bfseries}

\renewcommand{\cftchapfont}{\sffamily\bfseries}
\renewcommand{\cftchappagefont}{\sffamily\bfseries}

\renewcommand{\cftsecfont}{\sffamily}
\renewcommand{\cftsecpagefont}{\sffamily}

\renewcommand{\cftsubsecfont}{\sffamily}
\renewcommand{\cftsubsecpagefont}{\sffamily}

\newcommand{\printtoc}{%
	\cleardoublepage
	\pagestyle{plain}
	\tableofcontents
	\cleardoublepage
	\setcounter{page}{0}
	\pagestyle{thesisupb}
	\pagenumbering{arabic}
}

% Bibliography
\newcommand{\bibliographychapter}{%
	\cleardoublepage
	\phantomsection
	\if@german
		\addcontentsline{toc}{chapter}{Literaur}
	\else
		\addcontentsline{toc}{chapter}{Bibliography}
	\fi
	\printbibliography
}

% Variables
\newcommand{\@surname}{---}
\newcommand{\@name}{---}
\newcommand{\@matriculationnumber}{---}
\renewcommand{\@author}{\@name \@surname}
\renewcommand{\@title}{---}
\renewcommand{\@date}{---}
\newcommand{\@thesistype}{---}
\newcommand{\@degree}{---}
\newcommand{\@researchgroup}{---}
\newcommand{\@supervisor}{---}
\newcommand{\surname}[1]{\renewcommand{\@surname}{#1}}
\newcommand{\name}[1]{\renewcommand{\@name}{#1}}
\newcommand{\matriculationnumber}[1]{\renewcommand{\@matriculationnumber}{#1}}
\newcommand{\thesistype}[1]{\renewcommand{\@thesistype}{#1}}
\newcommand{\degree}[1]{\renewcommand{\@degree}{#1}}
\newcommand{\researchgroup}[1]{\renewcommand{\@researchgroup}{#1}}
\newcommand{\supervisor}[1]{\renewcommand{\@supervisor}{#1}}

% Abstract
\newcommand{\printabstract}[1]{%
	\cleardoublepage

	\begin{tikzpicture}[remember picture,overlay, shift={(current page.north west)}]
		\node[anchor=south east] at (\dimexpr \xgrid * 7 \relax,\dimexpr \ygrid * -7 \relax) {
			\parbox[c]{\dimexpr \xgrid * 3 - \fboxsep * 2 \relax}{
				\section*{Abstract}

				#1
			}
		};

		\fill[upbHighlight] (\xgrid,\dimexpr \ygrid * -1 \relax) rectangle ++(\xgrid,-\ygrid);
	\end{tikzpicture}
}

% Colophon
\newcommand{\colophon}{
	\clearpage
	\ifodd\value{page}
		\null\newpage
	\fi

	\thispagestyle{empty}

	\begin{tikzpicture}[remember picture,overlay, shift={(current page.north west)}]
		\node[anchor=south west] at (\dimexpr \xgrid * 2 \relax,\dimexpr \ygrid * -7 \relax) {
			\parbox[c]{\dimexpr \xgrid * 3 - \fboxsep * 2 \relax}{
				\if@german
					©~\the\year{}~\@author

					\bigskip

					Der Fließtext dieser Arbeit ist in Schriften der Latin Modern-Schriftsippe – der Latin Modern Roman, Latin Modern Mono und Latin Modern Mono Proportional – gesetzt.
					Die Schriften sind eine modernisierte Version der Computer Modern Schriften, die von Donald\,E.\,Knuth in den 1970er-Jahren entworfen wurden.
					Ihre Formen sind von der 1896 erstmals erschienenen Monotype Modern inspiriert, eine viktorianischen Schrift, die den Werken von Didot und Bodoni nachempfunden ist.

					\bigskip

					Die Überschriften sind in Karla gesetzt, eine von Jonathan Pinhown in den 2010er-Jahren entworfene Schriftart.
					Karla umfasst dabei nicht nur die lateinischen Buchstaben, wie sie hier Verwendung finden, sondern auch jene Zeichen, die zum Schreiben von Tamil benötigt werden.
					Dem Anspruch, die Formen der beiden Schriftsysteme harmonisch in einer Schriftart zu vereinen, sind die Karla auszeichnenden breiten und runden Formen der lateinischen Buchstaben geschuldet.

					\bigskip

					Mit \LaTeX{} gesetzt.
				\else
					©~\the\year{}~\@author

					\bigskip

					This thesis’ body copy is set using typefaces from the Latin Modern superfamily, namely Latin Modern Roman, Latin Modern Mono and Latin Modern Mono Proportional.
					These typefaces are a modernized version of the Computer Modern typefaces designed by Donald\,E.\,Knuth in the 1970s.
					The shapes take inspiration from the Monotype Modern typeface, which was first released in 1896—a Victorian era typeface in the wake of the works by Didot and Bodoni.

					\bigskip

					The captions are set in Karla, a typeface designed by Jonathan Pinhorn in the 2010s.
					Karla does not only contain the Latin letterforms seen here—Karla was also designed for the Tamil script.
					Hence, the typeface tries to achieve a harmonized look between these two different writing systems which is apparent in its wide and round glyphs.

					\bigskip

					Typeset using \LaTeX{}.
				\fi
			}
		};
	\end{tikzpicture}
}

% Part headings
\titleformat{\part}{
	\sffamily\huge\bfseries
}{}{0em}{
	\thispagestyle{empty}
	\begin{tikzpicture}[remember picture,overlay, shift={(current page.north west)}]
		\fill[upbHighlight] (\xgrid,\dimexpr \ygrid * -3 \relax) rectangle ++(\xgrid,-\ygrid);
		\node[anchor=south east,inner sep=0pt,text depth=0pt] at (\dimexpr \xgrid * 7 \relax,\dimexpr \ygrid * -5 \relax) {\parbox[b]{\dimexpr \xgrid * 3 \relax}{\flushright #1}};
		\node[anchor=south west,inner sep=0pt] at (\dimexpr \xgrid * 2 \relax,\dimexpr \ygrid * -4 \relax) {\resizebox{!}{15mm}{\textcolor{upbHighlight}{\ Part \thepart}}};
	\end{tikzpicture}
}

\titleformat{name=\part,numberless}{
	\sffamily\huge\bfseries
}{}{0em}{
	\thispagestyle{empty}
	\begin{tikzpicture}[remember picture,overlay, shift={(current page.north west)}]
		\fill[upbHighlight] (\xgrid,\dimexpr \ygrid * -3 \relax) rectangle ++(\xgrid,-\ygrid);
		\node[anchor=south east,inner sep=0pt,text depth=0pt] at (\dimexpr \xgrid * 7 \relax,\dimexpr \ygrid * -5 \relax) {\parbox[b]{\dimexpr \xgrid * 3 \relax}{\flushright #1}};
	\end{tikzpicture}
}

% Chapter headings
\titleformat{\chapter}{
	\sffamily\huge\bfseries
}{}{0em}{
	\begin{tikzpicture}[remember picture,overlay, shift={(current page.north west)}]
		\fill[upbHighlight] (\xgrid,\dimexpr \ygrid * -1 \relax) rectangle ++(\xgrid,-\ygrid);
		\node[anchor=south east,inner sep=0pt,text depth=0pt] at (\dimexpr \xgrid * 7 \relax,\dimexpr \ygrid * -2 \relax) {\parbox[b]{\dimexpr \xgrid * 3 \relax}{\flushright #1}};
		\node[anchor=south west,inner sep=0pt] at (\dimexpr \xgrid * 2 \relax,\dimexpr \ygrid * -2 \relax) {\resizebox{!}{15mm}{\ \textcolor{upbHighlight}{\thechapter}}};
	\end{tikzpicture}
}

\titleformat{name=\chapter,numberless}{
	\sffamily\huge\bfseries
}{}{0em}{
	\begin{tikzpicture}[remember picture,overlay, shift={(current page.north west)}]
		\fill[upbHighlight] (\xgrid,\dimexpr \ygrid * -1 \relax) rectangle ++(\xgrid,-\ygrid);
		\node[anchor=south east,inner sep=0pt,text depth=0pt] at (\dimexpr \xgrid * 7 \relax,\dimexpr \ygrid * -2 \relax) {\parbox[b]{\dimexpr \xgrid * 3 \relax}{\flushright #1}};
	\end{tikzpicture}
}

% Footer more towards the bottom of the page
\setlength{\footskip}{3\baselineskip}

% Layout of the title page
\newcommand{\printtitlepage}{
	\begin{titlepage}
		\sffamily

		\if@german
			\noindent\includegraphics[width=\dimexpr \xgrid * 3 \relax]{figures/logo_de}
		\else
			\noindent\includegraphics[width=\dimexpr \xgrid * 3 \relax]{figures/logo_en}
		\fi

		\begin{tikzpicture}[remember picture, overlay, shift={(current page.south west)}]
			\node[anchor=south west] at (\dimexpr \xgrid * 4 + 5mm \relax,\dimexpr \ygrid * 7 \relax) {
				\parbox[c][\dimexpr \ygrid - \fboxsep * 2 \relax]{\dimexpr \xgrid * 3 - \fboxsep * 2 - 5mm \relax}{
					\small
					\vspace*{11pt}
					\if@german
						Fakultät für Elektrotechnik, \\
						Informatik und Mathematik \\[5pt]
						Institut für Informatik
					\else
						Faculty for Computer Science, \\
						Electrical Engineering and Mathematics \\[5pt]
						Department of Computer Science
					\fi
				}
			};

			\filldraw[lightgray] (\dimexpr \xgrid * 4 - 0.8pt \relax, \dimexpr \ygrid * 7 + \ygrid * 1/8 \relax) -- ++(0,\dimexpr \ygrid * 3/4 \relax) -- ++(38:2pt) -- ++(0,\dimexpr \ygrid * -3/4 \relax) -- cycle;

			\node[anchor=north west] (ThesisType) at (\xgrid,\dimexpr \ygrid * 13/2 \relax) {
				\parbox[c]{\dimexpr \xgrid * 6 - \fboxsep * 2 \relax}{
					\centering\huge
					\@thesistype
				}
			};

			\node[below=5pt of ThesisType] (SubmittedTo) {
				\parbox[c]{\dimexpr \xgrid * 6 - \fboxsep * 2 \relax}{
					\centering
					\if@german
						Gerichtet an die Arbeitsgruppe \@researchgroup\\
						zur Erreichung des Grades
					\else
						Submitted to the \@researchgroup\ research group\\
						in partial fulfilment of the requirements for the degree of
					\fi
				}
			};

			\node[below=5pt of SubmittedTo] (Degree) {
				\parbox[c]{\dimexpr \xgrid * 6 - \fboxsep * 2 \relax}{
					\centering\huge
					\@degree{}
				}
			};

			\node[anchor=south west] (Author) at (\xgrid,\dimexpr \ygrid * 3 \relax) {
				\parbox[c]{\dimexpr \xgrid * 6 - \fboxsep * 2 \relax}{
					\centering
					\if@german
						von \\
					\else
						by \\
					\fi
					\Large\@author
				}
			};

			\node[anchor=north west] at (\xgrid,\dimexpr \ygrid * 3 - 15pt \relax) {
				\parbox[c]{\dimexpr \xgrid * 6 - \fboxsep * 2 \relax}{
					\centering
					\if@german
						Betreut durch \\
					\else
						Thesis Supervisor \\
					\fi
					\Large\@supervisor
				}
			};

			\node[anchor=south  west] at (\xgrid,\dimexpr \ygrid * 2 \relax) {
				\parbox[c]{\dimexpr \xgrid * 6 - \fboxsep * 2 \relax}{
					\centering
					Paderborn, \@date
				}
			};

			\path (Degree) -- (Author) node[midway] {
				\parbox[c]{\dimexpr \xgrid * 6 - \fboxsep * 2 \relax}{
					\centering\huge\bfseries\baselineskip25pt
					\@title
				}
			};

		\end{tikzpicture}
	\end{titlepage}
}

% Color definitions
\definecolor{upbUltraBlue}{RGB}{0,37,170}
\definecolor{upbSkyBlue}{RGB}{10,117,196}
\definecolor{upbSapphireBlue}{RGB}{24,28,98}
\definecolor{upbIrisViolet}{RGB}{126,63,168}
\definecolor{upbFuchsiaRed}{RGB}{193,56,160}
\definecolor{upbOceanBlue}{RGB}{35,169,201}
\definecolor{upbArcticBlue}{RGB}{80,209,209}
\definecolor{upbGarnetPink}{RGB}{238,40,138}
\definecolor{upbLimeGreen}{RGB}{165,206,66}

% Define boxes
\tcbset { 
	base/.style={
		breakable,
		% Outer box
		enhanced jigsaw,
	    arc=0mm, 
	    boxrule=0mm,
	    leftrule=1mm,
		% Colors
		colbacktitle={white},
		opacitybacktitle=0,
		colback={white},
		opacityback=0,
		% Title
	    coltitle=black, 
	    fonttitle=\sffamily\bfseries, 
		% Margins
		before skip balanced=\dimexpr \baselineskip + 2pt \relax,
		after skip balanced=\dimexpr \baselineskip + 2pt \relax,
	    left=2.5mm,
	    right=3.5mm,
	}
}

\newtcolorbox{upbbox}[1][black]{
	% Colors
	colframe={#1},
	% See definition of base
	base
}

\newtcolorbox{upbtitlebox}[2][black]{
	% Colors
	colframe={#1},
	% Title text
	title={#2},
	% Margins
	toptitle=1mm, 
	bottomtitle=1mm,
	top=1mm,
	% See definition of base
	base
}

% Math environments
% Definition
\newcounter{definition}

\newenvironment{definition}[1]
{
	\refstepcounter{definition}
	\begin{upbtitlebox}[upbSapphireBlue]{Definition~\thedefinition: \mdseries #1}
}
{
	\end{upbtitlebox}
}

\if@german
	\crefname{definition}{Definition}{Definitionen}
	\Crefname{definition}{Definition}{Definitionen}
	\crefformat{definition}{#2Definition~#1#3}
	\Crefformat{definition}{#2Definition~#1#3}
	\crefrangeformat{definition}{#3Definitionen~#1#4 bis~#5#2#6}
	\Crefrangeformat{definition}{#3Definitionen~#1#4 bis~#5#2#6}
	\crefmultiformat{definition}{Definitionen~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{definition}{Definitionen~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{definition}{definition}{definitions}
	\Crefname{definition}{Definition}{Definitions}
	\crefformat{definition}{#2definition~#1#3}
	\Crefformat{definition}{#2Definition~#1#3}
	\crefrangeformat{definition}{#3definitions~#1#4 to~#5#2#6}
	\Crefrangeformat{definition}{#3Definitions~#1#4 to~#5#2#6}
	\crefmultiformat{definition}{definitions~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{definition}{Definitions~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Observation
\newcounter{observation}

\newenvironment{observation}[1]
{
	\refstepcounter{observation}
	\if@german
		\begin{upbtitlebox}[upbLimeGreen]{Beobachtung~\theobservation: \mdseries #1}
	\else
		\begin{upbtitlebox}[upbLimeGreen]{Observation~\theobservation: \mdseries #1}
	\fi
}
{
	\end{upbtitlebox}
}

\if@german
	\crefname{observation}{Beobachtung}{Beobachtungen}
	\Crefname{observation}{Beobachtung}{Beobachtungen}
	\crefformat{observation}{#2Beobachtung~#1#3}
	\Crefformat{observation}{#2Beobachtung~#1#3}
	\crefrangeformat{observation}{#3Beobachtungen~#1#4 bis~#5#2#6}
	\Crefrangeformat{observation}{#3Beobachtungen~#1#4 bis~#5#2#6}
	\crefmultiformat{observation}{Beobachtungen~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{observation}{Beobachtungen~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{observation}{observation}{observations}
	\Crefname{observation}{Observation}{Observations}
	\crefformat{observation}{#2observation~#1#3}
	\Crefformat{observation}{#2Observation~#1#3}
	\crefrangeformat{observation}{#3observations~#1#4 to~#5#2#6}
	\Crefrangeformat{observation}{#3Observations~#1#4 to~#5#2#6}
	\crefmultiformat{observation}{observations~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{observation}{Observations~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Theorem
\newcounter{theorem}

\newenvironment{theorem}[1]
{
	\refstepcounter{theorem}
	\if@german
		\begin{upbtitlebox}[black]{Satz~\thetheorem: \mdseries #1}
	\else
		\begin{upbtitlebox}[black]{Theorem~\thetheorem: \mdseries #1}
	\fi
}
{
	\end{upbtitlebox}
}
\if@german
	\crefname{theorem}{Satz}{Sätze}
	\Crefname{theorem}{Satz}{Sätze}
	\crefformat{theorem}{#2Satz~#1#3}
	\Crefformat{theorem}{#2Satz~#1#3}
	\crefrangeformat{theorem}{#3Sätze~#1#4 bis~#5#2#6}
	\Crefrangeformat{theorem}{#3Sätze~#1#4 bis~#5#2#6}
	\crefmultiformat{theorem}{Sätze~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{theorem}{Sätze~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{theorem}{theorem}{theorems}
	\Crefname{theorem}{Theorem}{Theorems}
	\crefformat{theorem}{#2theorem~#1#3}
	\Crefformat{theorem}{#2Theorem~#1#3}
	\crefrangeformat{theorem}{#3theorems~#1#4 to~#5#2#6}
	\Crefrangeformat{theorem}{#3Theorems~#1#4 to~#5#2#6}
	\crefmultiformat{theorem}{theorems~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{theorem}{Theorems~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Lemma
\newcounter{lemma}

\newenvironment{lemma}[1]
{
	\refstepcounter{lemma}
	\begin{upbtitlebox}[upbIrisViolet]{Lemma~\thelemma: \mdseries #1}
}
{
	\end{upbtitlebox}
}

\Crefname{lemma}{Lemma}{Lemmata}
\Crefformat{lemma}{#2Lemma~#1#3}
\if@german
	\crefname{lemma}{Lemma}{Lemmata}
	\crefformat{lemma}{#2Lemma~#1#3}
	\crefrangeformat{lemma}{#3Lemmata~#1#4 bis~#5#2#6}
	\Crefrangeformat{lemma}{#3Lemmata~#1#4 bis~#5#2#6}
	\crefmultiformat{lemma}{Lemmata~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{lemma}{Lemmata~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{lemma}{lemma}{lemmata}
	\crefformat{lemma}{#2lemma~#1#3}
	\Crefformat{lemma}{#2Lemma~#1#3}
	\crefrangeformat{lemma}{#3lemmata~#1#4 to~#5#2#6}
	\Crefrangeformat{lemma}{#3Lemmata~#1#4 to~#5#2#6}
	\crefmultiformat{lemma}{lemmata~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{lemma}{Lemmata~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Corollary
\newcounter{corollary}

\newenvironment{corollary}[1]
{
	\refstepcounter{corollary}
	\if@german
		\begin{upbtitlebox}[upbGarnetPink]{Korollar~\thecorollary: \mdseries #1}
	\else
		\begin{upbtitlebox}[upbGarnetPink]{Corollary~\thecorollary: \mdseries #1}
	\fi
}
{
	\end{upbtitlebox}
}

\if@german
	\crefname{corollary}{Korollar}{Korollare}
	\Crefname{corollary}{Korollar}{Korollare}
	\crefformat{corollary}{#2Korollar~#1#3}
	\Crefformat{corollary}{#2Korollar~#1#3}
	\crefrangeformat{corollary}{#3Korollare~#1#4 bis~#5#2#6}
	\Crefrangeformat{corollary}{#3Korollare~#1#4 bis~#5#2#6}
	\crefmultiformat{corollary}{Korollare~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
	\Crefmultiformat{corollary}{Korollare~#2#1#3}{ und~#2#1#3}{, #2#1#3}{ und~#2#1#3}
\else
	\crefname{corollary}{corollary}{corollaries}
	\Crefname{corollary}{Corollary}{Corollaries}
	\crefformat{corollary}{#2corollary~#1#3}
	\Crefformat{corollary}{#2Corollary~#1#3}
	\crefrangeformat{corollary}{#3corollaries~#1#4 to~#5#2#6}
	\Crefrangeformat{corollary}{#3Corollaries~#1#4 to~#5#2#6}
	\crefmultiformat{corollary}{corollaries~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
	\Crefmultiformat{corollary}{Corollaries~#2#1#3}{ and~#2#1#3}{, #2#1#3}{ and~#2#1#3}
\fi

% Proof
\renewenvironment{proof}[1]
{
	\pushQED{\qed}%
	\if@german
		\begin{upbtitlebox}[black!25]{Beweis: \mdseries #1}
	\else
		\begin{upbtitlebox}[black!25]{Proof: \mdseries #1}
	\fi
}
{
	\popQED\endtrivlist\@endpefalse
	\end{upbtitlebox}
}

% Layout of the affirmation in lieu of an oath
\newcommand{\printaffirmation}[1]{
	\begin{selectlanguage}{ngerman}
		\clearpage

		\begin{tikzpicture}[remember picture,overlay, shift={(current page.north west)}]
			\node[anchor=south east] at (\dimexpr \xgrid * 6 \relax,\dimexpr \ygrid * -7 \relax) {
				\parbox[c]{\dimexpr \xgrid * 4 - \fboxsep * 2 \relax}{
					\section*{Belehrung}
					Wer vorsätzlich gegen eine die Täuschung über Prüfungsleistungen betreffende Regelung einer Hochschulprüfungsordnung verstößt, handelt ordnungswidrig.
					Die Ordnungswidrigkeit kann mit einer Geldbuße von bis zu 50.000,00\,€ geahndet werden.
					Zuständige Verwaltungsbehörde für die Verfolgung und Ahndung von Ordnungswidrigkeiten ist die Vizepräsident:in für Wirtschafts- und Personalverwaltung der Universität Paderborn. 
					Im Falle eines mehrfachen oder sonstigen schwerwiegenden Täuschungsversuches kann der Prüfling zudem exmatrikuliert werden (§\,63~Abs.\,5~HG~NRW).
					Die Universität Paderborn wird ggf. eine elektronische Überprüfung der Abschlussarbeit durchführen, um eine Täuschung festzustellen.

					\section*{Hinweis zu der Verarbeitung personenbezogener Daten}
					Die auf der folgenden Seite  genannten Daten werden aufgrund der geltenden Prüfungsordnung i.\,V.\,m. §\,63~Abs.\,5~HG~NRW erhoben.
					Auf Grundlage der übermittelten Daten wird bei Plagiaten bzw. Täuschung der:die Prüfende und der Prüfungsausschuss des betroffenen Studienganges über Konsequenzen gemäß Prüfungsordnung i.\,V.\,m. dem Hochschulgesetz NRW entscheiden. 
					Die Daten werden nach Abschluss des Prüfungsverfahrens gelöscht.
					Eine Weiterleitung der Daten kann an den Prüfende:n und den Prüfungsausschuss erfolgen.
					Falls der Prüfungsausschuss entscheidet, eine Geldbuße zu verhängen, werden die Daten an die Vizepräsident:in für Wirtschafts- und Personalverwaltung weitergeleitet, welche für die Verfolgung und Ahndung der Geldbuße zuständig ist.
					Verantwortlich für die Verarbeitung im regulären Verfahren ist der Prüfungsausschuss des betroffenen Studiengangs der Universität Paderborn.
				}
			};
		\end{tikzpicture}

		\clearpage

		\begin{tikzpicture}[remember picture,overlay, shift={(current page.north west)}]
			\fill[upbHighlight] (\xgrid,\dimexpr \ygrid * -1 \relax) rectangle ++(\xgrid,-\ygrid);
			\node[anchor=south east,inner sep=0pt,text depth=0pt] at (\dimexpr \xgrid * 7 \relax,\dimexpr \ygrid * -2 \relax) {\parbox[b]{\dimexpr \xgrid * 3 \relax}{\flushright\sffamily\huge\bfseries Eidesstattliche Versicherung}};

			\fill[upbHighlight] (\xgrid,\dimexpr \ygrid * -1 \relax) rectangle ++(\xgrid,-\ygrid);
		\end{tikzpicture}

		\vspace{\dimexpr \ygrid + 25pt \relax}

		\noindent
		\begin{tblr}{
			cell{5}{1}={c=2}{l},
			cell{6}{1}={c=2}{l},
			cell{7}{1}={c=2}{l},
			cell{8}{1}={c=2}{l},
			row{odd}={font=\footnotesize\sffamily, rowsep=0pt},
			column{1}={wd=\dimexpr3\xgrid-12pt, leftsep=0pt},
			column{2}={wd=\dimexpr3\xgrid-12pt, rightsep=0pt},
			colspec={ll}
		}
			Name                                                                                              & Vorname                                                                                         \\
			\fbox{\parbox{\dimexpr \linewidth - 2\fboxsep - 2\fboxrule \relax}{\@surname\strut}}              & \fbox{\parbox{\dimexpr \linewidth - 2\fboxsep - 2\fboxrule \relax}{\@name\strut}}               \\
			Matrikelnummer                                                                                    & Studiengang                                                                                     \\
			\fbox{\parbox{\dimexpr \linewidth - 2\fboxsep - 2\fboxrule \relax}{\@matriculationnumber\strut}}  & \fbox{\parbox{\dimexpr \linewidth - 2\fboxsep - 2\fboxrule \relax}{Informatik, \@degree\strut}} \\
			Titel                                                                                             &                                                                                                 \\
			\fbox{\parbox{\dimexpr \linewidth - 2\fboxsep - 2\fboxrule \relax}{\@title\strut}}                &                                                                                                 \\
			Hilfsmittel                                                                                       &                                                                                                 \\
			\fbox{\parbox{\dimexpr \linewidth - 2\fboxsep - 2\fboxrule \relax}{#1\strut}}                     &                                                                                                 \\
		\end{tblr}

		\vspace{2\baselineskip}

		\noindent Ich versichere hiermit an Eides statt, dass ich die vorliegende Abschlussarbeit selbstständig und ohne unzulässige fremde Hilfe erbracht habe.
		\begin{itemize}
			\item Ich habe die oben genannten Belehrungen gelesen und verstanden.
			\item Ich habe keine anderen als die angegebenen Quellen und Hilfsmittel benutzt sowie wörtliche und sinngemäße Zitate kenntlich gemacht.
			\item Die Abschlussarbeit hat in gleicher oder ähnlicher Form noch keiner Prüfungsbehörde vorgelegen.
			\item Die elektronische Fassung entspricht der gedruckten und gebundenen Fassung.
		\end{itemize}

		\vspace{0.75\ygrid}

		\noindent
		\begin{tblr}{
			cell{2}{2}={font=\footnotesize, halign=c, valign=t},
			colspec={lX},
			colsep=12pt,
			column{1}={leftsep=0pt},
			column{2}={rightsep=0pt},
			stretch=0
		}
			\raisebox{1em}{Paderborn, den \today{}} & \hrulefill   \\
													& Unterschrift \\
		\end{tblr}
	\end{selectlanguage}
}

% Up to the first content page, pages should not have page numbers
\pagestyle{empty}
\pagenumbering{gobble}

% Semantic markup
\newcommand{\code}[1]{\texttt{#1}}
\newcommand{\term}[1]{\textsc{#1}}
\newcommand{\todo}[1]{\colorbox{upbFuchsiaRed}{\sffamily\strong{\textcolor{white}{#1}}}}

% Abbreviations
\if@german
	\newcommand\zB{z.\,B.}
	\newcommand\ua{u.\,a.}
	\newcommand\uAe{u.\,Ä.}
	\newcommand\oAe{o.\,Ä.}
\fi

